ToggleRotorArmEvent = {}
local ToggleRotorArmEvent_mt = Class(ToggleRotorArmEvent, Event)

InitEventClass(ToggleRotorArmEvent, "ToggleRotorArmEvent")

function ToggleRotorArmEvent.emptyNew()
	local self = Event.new(ToggleRotorArmEvent_mt)

	return self
end

function ToggleRotorArmEvent.new(object, index)
	local self = ToggleRotorArmEvent.emptyNew()
	self.object = object
	self.index = index

	return self
end

function ToggleRotorArmEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.index = streamReadInt8(streamId)

	self:run(connection)
end

function ToggleRotorArmEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteInt8(streamId, self.index)
end

function ToggleRotorArmEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(ToggleRotorArmEvent.new(self.object, self.index), nil, connection, self.object)
	end
	
	if self.object ~= nil and self.object:getIsSynchronized() then
		self.object:toggleRotorArm(self.index, true)
	end
end

function ToggleRotorArmEvent.sendEvent(vehicle, index, noEventSend)
	if vehicle.spec_individualLowering ~= nil and (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleRotorArmEvent.new(vehicle, index), nil, false, vehicle)
		else
			g_client:getServerConnection():sendEvent(ToggleRotorArmEvent.new(vehicle, index))
		end
	end
end
