SetFieldWorkerStateEvent = {}
local SetFieldWorkerStateEvent_mt = Class(SetFieldWorkerStateEvent, Event)

InitEventClass(SetFieldWorkerStateEvent, "SetFieldWorkerStateEvent")

function SetFieldWorkerStateEvent.emptyNew()
	local self = Event.new(SetFieldWorkerStateEvent_mt)

	return self
end

function SetFieldWorkerStateEvent.new(object, state)
	local self = SetFieldWorkerStateEvent.emptyNew()
	self.object = object
	self.state = state

	return self
end

function SetFieldWorkerStateEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.state = streamReadBool(streamId)

	self:run(connection)
end

function SetFieldWorkerStateEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.state)
end

function SetFieldWorkerStateEvent:run(connection)
	if self.object ~= nil and self.object:getIsSynchronized() then
		self.object:setFieldWorkerState(self.state, true)
	end

	if not connection:getIsServer() then
		g_server:broadcastEvent(SetFieldWorkerStateEvent.new(self.object, self.state), nil, connection, self.object)
	end
end

function SetFieldWorkerStateEvent.sendEvent(vehicle, state, noEventSend)
	if vehicle.spec_individualLowering ~= nil and (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFieldWorkerStateEvent.new(vehicle, state), nil, false, vehicle)
		else
			g_client:getServerConnection():sendEvent(SetFieldWorkerStateEvent.new(vehicle, state))
		end
	end
end
