--[[
    Author: PeterAH
    Mod name: Improved Harvester Sounds
    Version: 1.1.0.0
    Date: March 2024
    Support: https://www.modding-welt.com
    Discord: @peter_ah
]]


if g_specializationManager:getSpecializationByName("improvedHarvesterSounds") == nil then
    g_specializationManager:addSpecialization('improvedHarvesterSounds', 'improvedHarvesterSounds', Utils.getFilename('improvedHarvesterSounds.lua', g_currentModDirectory), nil)
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(improvedHarvesterSounds, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Wheels, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Enterable, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Locomotive, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(SplineVehicle, vehicleType.specializations) then
    elseif vehicleTypeName == 'locomotive' then
    elseif vehicleTypeName == 'conveyorBelt' then
    else
      --  print(vehicleTypeName)
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'improvedHarvesterSounds')
    end 
end

local modDescFile = loadXMLFile("modDescFile", g_currentModDirectory .. "modDesc.xml")
local _standardCategories = Utils.getNoNil(getXMLString(modDescFile, "modDesc.harvesterSounds#standardCategorie"), "")
_standardCategories = "/" .. string.upper(_standardCategories) .. "/"
_allUsedCategories = _standardCategories
local _configName = {}
local _configNameDE = {}
local _setConfigToDefault = {}
local _setConfigToDefault2 = {}
local _brand = {}
local _category ={}
local _search = {}
local _search2 = {}
local _exclude = {}
local _exclude2 = {}
local i = 0
while true do
    local keyPath = "modDesc.improvedHarvesterSounds.harvesterSound(" .. tostring(i) .. ")"
    if not hasXMLProperty(modDescFile, keyPath) then
        break
    end
    _configName[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#configName"), "")
    _configNameDE[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#configNameDE"), "")
    if _configNameDE[i+2] ~= "" then
        if g_gui.languageSuffix == "_de" then
            _configName[i+2] = _configNameDE[i+2]
        end
    end
    _setConfigToDefault[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#defaultConfig"), "")
    _setConfigToDefault2[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#defaultConfig2"), "")

    _brand[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#brand"), "")
    _category[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#category"), "")
    if _category[i+2] == "" then
        _category[i+2] = _standardCategories
    else
        _category[i+2] = "/" .. string.upper(_category[i+2]) .. "/"
        if _category[i+2] ~= _standardCategories then
            _allUsedCategories = _allUsedCategories .. _category[i+2]
        end
    end

    _search[i+2] = string.lower(Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#search"), ""))
    _search2[i+2] = string.lower(Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#search2"), "no__search"))
    if _search[i+2] == "" then
        if _search2[i+2] ~= "no__search" then
            _search[i+2] = _search2[i+2]
        end
    end

    _exclude[i+2] = string.lower(Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#exclude"), ""))
    _exclude2[i+2] = string.lower(Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#exclude2"), ""))

    i = i + 1
end
delete(modDescFile)

function initNewStoreConfig()
    --print("initNewStoreConfig =================================")
    g_configurationManager:addConfigurationType("improvedHarvesterSounds", g_i18n:getText("CONFIG_TITLE"), nil, nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION)
	StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, addNewStoreConfig)
end

function addNewStoreConfig(xmlFile, superFunc, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
	local configurations = superFunc(xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)

    local category = "no category found"
    if storeItem == nil then
    elseif configurations == nil then
    elseif configurations["improvedHarvesterSounds"] ~= nil then
    else
        category = "/" .. string.upper(storeItem.categoryName) .. "/"
        if storeItem.isMod == false then
        elseif string.find("/TRACTORSS/TRACTORSM/TRACTORSL/TRUCKS/HARVESTERS/FORAGEHARVESTERS/POTATOVEHICLES/BEETVEHICLES/TRAILERS/PLOWS/CULTIVATORS/POWERHARROWS/SEEDERS/BIGBAGPALLETS/BIGBAGS/PALLETS/BALES/", category) then
        else
            -- For harvesters in user defined, custom categories
            local vehicleXmlFile = XMLFile.load("vehicle", storeItem.xmlFilename, Vehicle.xmlSchema)
            for i = 0, 6 do    
                if vehicleXmlFile:hasProperty("vehicle.attacherJoints.attacherJoint(" .. tostring(i) .. ")#node") then
                    if vehicleXmlFile:hasProperty("vehicle.attacherJoints.attacherJoint(" .. tostring(i) .. ")#jointType") then
                        local jointType = vehicleXmlFile:getValue("vehicle.attacherJoints.attacherJoint(" .. tostring(i) .. ")#jointType")
                        if jointType ~= nil then
                            if jointType == "cutter" then
                                category = "/HARVESTERS/"
                            elseif jointType == "cutterHarvester" then
                                category = "/FORAGEHARVESTERS/"
                            end
                        end
                    end
                else
                    break
                end
            end
            vehicleXmlFile:delete()

        end
    end

    -- print(DebugUtil.printTableRecursively(storeItem, 0, 0, 1))

    --if category == "TRACTORS" then
    if string.find(_allUsedCategories, category) then

        configurations["improvedHarvesterSounds"] = {
            {name = g_i18n:getText("CONFIG_STANDARD_SOUND"), index = 1, isDefault = true,  price = 0, dailyUpkeep = 0, isSelectable = true}
        }

--print(storeItem.brandNameRaw)
        local j = 2
        local i = 2
        local name = string.lower(storeItem.name)
        if string.find(name, "mega 20") then
            name = "dominator " .. name
        end
        while _configName[j] ~= nil do
            if _brand[j] == "" or _brand[j] == string.upper(storeItem.brandNameRaw) then
                if string.find(_category[j], category) then
                    if _search[j] == "" or string.find(storeItem.xmlFilenameLower, _search[j]) or string.find(name, _search[j]) or string.find(storeItem.xmlFilenameLower, _search2[j]) or string.find(name, _search2[j]) then
                        if not string.find(name, _exclude[j]) or _exclude[j] == "" then
                            if not string.find(name, _exclude2[j]) or _exclude2[j] == "" then
                                configurations["improvedHarvesterSounds"][i] = {}
                                configurations["improvedHarvesterSounds"][i].name = _configName[j]
                                configurations["improvedHarvesterSounds"][i].index = i
                                configurations["improvedHarvesterSounds"][i].indexMMS = j
                                configurations["improvedHarvesterSounds"][i].isDefault = false
                                configurations["improvedHarvesterSounds"][i].price = 0
                                configurations["improvedHarvesterSounds"][i].dailyUpkeep = 0
                                configurations["improvedHarvesterSounds"][i].isSelectable = true
                                if i == 2 then
                                    configurations["improvedHarvesterSounds"][i].setConfigToDefault = _setConfigToDefault[j]
                                    configurations["improvedHarvesterSounds"][i].setConfigToDefault2 = _setConfigToDefault2[j]
                                end
                                i = i + 1
                            end
                        end
                    end
                end
            end
            j = j + 1
        end

        -- Change default config from Standard Sound to New Sound
        if configurations["improvedHarvesterSounds"][2] ~= nil then
            if storeItem.isMod == false then
                configurations["improvedHarvesterSounds"][1].isDefault = false
                configurations["improvedHarvesterSounds"][2].isDefault = true
            elseif configurations["improvedHarvesterSounds"][2].setConfigToDefault ~= "" then
                if string.find(name, configurations["improvedHarvesterSounds"][2].setConfigToDefault) then
                    configurations["improvedHarvesterSounds"][1].isDefault = false
                    configurations["improvedHarvesterSounds"][2].isDefault = true
                elseif configurations["improvedHarvesterSounds"][2].setConfigToDefault2 ~= "" then
                    if string.find(name, configurations["improvedHarvesterSounds"][2].setConfigToDefault2) then
                        configurations["improvedHarvesterSounds"][1].isDefault = false
                        configurations["improvedHarvesterSounds"][2].isDefault = true
                    end
                end                
            end
            configurations["improvedHarvesterSounds"][2].setConfigToDefault = nil
            configurations["improvedHarvesterSounds"][2].setConfigToDefault2 = nil
        end

    end

    return configurations
end

if g_configurationManager.configurations["improvedHarvesterSounds"] == nil then
    initNewStoreConfig()
end
