--[[
    Author: PeterAH
    Mod name: Improved Harvester Sounds
    Version: 1.1.0.0
    Date: March 2024
    Support: https://www.modding-welt.com
    Discord: @peter_ah
]]

improvedHarvesterSounds = {}
local _modDirectory = g_currentModDirectory
local _modName = g_currentModName

function improvedHarvesterSounds.prerequisitesPresent(specializations)
    return true
end

function improvedHarvesterSounds.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", improvedHarvesterSounds)
    SpecializationUtil.registerEventListener(vehicleType, "onPostAttachImplement", improvedHarvesterSounds)
    SpecializationUtil.registerEventListener(vehicleType, "onPreDetachImplement", improvedHarvesterSounds)
end

function improvedHarvesterSounds.initSpecialization()
    local schemaSavegame = Vehicle.xmlSchemaSavegame
    schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?)." .. _modName .. ".improvedHarvesterSounds#configurationId", "More motor sounds configuration id", 1)
end

local modDescFile = loadXMLFile("modDescFile", g_currentModDirectory .. "modDesc.xml")
local soundFile = {}
local i = 0
while true do
    local keyPath = "modDesc.improvedHarvesterSounds.harvesterSound(" .. tostring(i) .. ")"
    if not hasXMLProperty(modDescFile, keyPath) then
        break
    end
    soundFile[i+2] = Utils.getNoNil(getXMLString(modDescFile, keyPath .. "#soundFile"), "")
    i = i + 1
end
delete(modDescFile)

function improvedHarvesterSounds:onPreLoad(savegame)
    self.isCombine = false

    if SpecializationUtil.hasSpecialization(Honk, self.specializations) then
        Honk.onLoad = Utils.overwrittenFunction(Honk.onLoad, improvedHarvesterSounds.onLoadHonk)
    end
    -- if SpecializationUtil.hasSpecialization(Lights, self.specializations) then
    --     Lights.onLoad = Utils.overwrittenFunction(Lights.onLoad, improvedHarvesterSounds.onLoadLights)
    -- end
    if SpecializationUtil.hasSpecialization(TurnOnVehicle, self.specializations) then
        TurnOnVehicle.onLoad = Utils.overwrittenFunction(TurnOnVehicle.onLoad, improvedHarvesterSounds.onLoadTurnOnVehicle)
    end
   -- print("--- 1 ------------------------------------------------")
    if SpecializationUtil.hasSpecialization(Combine, self.specializations) then
       -- print("--- 2.1 ------------------------------------------------")
       -- Combine.loadCombineSamples = Utils.overwrittenFunction(Combine.loadCombineSamples, improvedHarvesterSounds.preLoadCombineSamples)
        self.loadCombineSamples = Utils.prependedFunction(Combine.loadCombineSamples, improvedHarvesterSounds.preLoadCombineSamples)
        Combine.onLoad = Utils.overwrittenFunction(Combine.onLoad, improvedHarvesterSounds.onLoadCombine)
    end

    local configurationId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 0)
    if savegame ~= nil then
        if configurationId > 0 then
            configurationId = savegame.xmlFile:getValue(savegame.key .. "." .. _modName .. ".improvedHarvesterSounds#configurationId", configurationId)
            if configurationId < 1 then
                configurationId = 1
            end
            self.configurations["improvedHarvesterSounds"] = configurationId
        end
    end
    --  print(self.configurations["improvedHarvesterSounds"])
    
    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    local indexMMS = 1
    if configId >= 2 then
        local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName)
        if storeItem ~= nil and storeItem.configurations ~= nil then
            if storeItem.configurations["improvedHarvesterSounds"] ~= nil then
                if storeItem.configurations["improvedHarvesterSounds"][configId] ~= nil then
                    if storeItem.configurations["improvedHarvesterSounds"][configId].indexMMS ~= nil then
                        indexMMS = storeItem.configurations["improvedHarvesterSounds"][configId].indexMMS
                    end
                end
            end
        end

        if indexMMS >= 2 then
            self.externalSoundsFilename = _modDirectory .. soundFile[indexMMS]
            if self.externalSoundsFile ~= nil then
                self.externalSoundsFile:delete()
            end
            self.externalSoundsFile = XMLFile.load("TempExternalSounds", self.externalSoundsFilename, Vehicle.xmlSchemaSounds)

            -- Only fr forage harvester: set volumeScale of dischargeSound to "0.0"
            if storeItem ~= nil and storeItem.categoryName ~= nil then
                if storeItem.categoryName == "FORAGEHARVESTERS" then

                    for i = 0, 5 do
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#template") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#template")
                            setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#template", "DEFAULT_SILO_FILL")
                            if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale") then
                                removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale")
                            end
                            setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale", "10.0")
                            if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#pitchScale") then
                                removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#pitchScale")
                            end
                            setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#pitchScale", "0.4")
                            -- Fix 1.1.0.0 for Giants Jaguar 930-980 begin (23.03.2024)
                            if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#outdoor") then
                                removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#outdoor")
                                setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#outdoor", "0.27")
                            end
                            if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#indoor") then
                                removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#indoor")
                                setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound.volume#indoor", "0.1")
                            end
                            -- Fix 1.1.0.0 for Giants Jaguar 930-980 end
                        elseif hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#linkNode") then
                            if hasXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale") then
                                removeXMLProperty(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale")
                            end
                            setXMLString(self.xmlFile.handle, "vehicle.dischargeable.dischargeNode(" .. tostring(i) .. ").dischargeSound#volumeScale", "0.0")
                        end
                    end

                elseif storeItem.categoryName == "HARVESTERS" then
                    self.isConfiguredCombine = true
                end

                -- Avoid errors, if a mod has the combine sounds in the in the vehicle-xml and not in the sound-xml
                if SpecializationUtil.hasSpecialization(Combine, self.specializations) then
                    if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#file")
                            setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.start#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.start#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.start#volumeScale", "0.0")
                    end

                    if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#file")
                            setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.work#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.work#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.work#volumeScale", "0.0")
                    end

                    if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#file")
                            setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.stop#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.combine.sounds.stop#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.combine.sounds.stop#volumeScale", "0.0")
                    end
                end

                -- Avoid errors, if a mod has the turnOnVehicle sounds in the in the vehicle-xml and not in the sound-xml
                if SpecializationUtil.hasSpecialization(TurnOnVehicle, self.specializations) then
                    if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#file")
                            setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.start#volumeScale", "0.0")
                    end

                    if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#file")
                            setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.work#volumeScale", "0.0")
                    end

                    if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#file") or hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#template") then
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#file") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#file")
                            setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#file", "$data/sounds/tools/harvest/combineHarvesterLoop.ogg")
                        end
                        if hasXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#volumeScale") then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#volumeScale")
                        end
                        setXMLString(self.xmlFile.handle, "vehicle.turnOnVehicle.sounds.stop#volumeScale", "0.0")
                    end
                end

            end

        else
            self.configurations["improvedHarvesterSounds"] = 1
        end

    end
    
end

function improvedHarvesterSounds:loadSounds(superFunc, xmlFile, baseString)
    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId == 1 then
        superFunc(self, xmlFile, baseString)
    else
        local baseDirectoryBackup = self.baseDirectory
        self.baseDirectory = _modDirectory
        superFunc(self, xmlFile, baseString)
        self.baseDirectory = baseDirectoryBackup        
    end
end
Motorized.loadSounds = Utils.overwrittenFunction(Motorized.loadSounds, improvedHarvesterSounds.loadSounds)

function improvedHarvesterSounds:onLoadHonk(superFunc, savegame)
    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId == 1 then
        superFunc(self, savegame)
    else
        local baseDirectoryBackup = self.baseDirectory
        self.baseDirectory = _modDirectory
        superFunc(self, savegame)
        self.baseDirectory = baseDirectoryBackup        
    end
end
--[[
function improvedHarvesterSounds:onLoadLights(superFunc, savegame)
    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId == 1 then
        superFunc(self, savegame)
    else
        local baseDirectoryBackup = self.baseDirectory
        self.baseDirectory = _modDirectory
        superFunc(self, savegame)
        self.baseDirectory = baseDirectoryBackup        
    end
end
]]
function improvedHarvesterSounds:onLoadTurnOnVehicle(superFunc, savegame)
    -- print("--- 3 ------------------------------------------------")

    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId == 1 then
        superFunc(self, savegame)
    else
        local baseDirectoryBackup = self.baseDirectory
        self.baseDirectory = _modDirectory
        superFunc(self, savegame)
        self.baseDirectory = baseDirectoryBackup        
    end
end

function improvedHarvesterSounds:preLoadCombineSamples(xmlFile, key, entry)
    -- print("--- 4 ------------------------------------------------")

    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId > 1 then
        self.baseDirectoryBackup = self.baseDirectory
        self.baseDirectory = _modDirectory
    end
end

function improvedHarvesterSounds:onLoadCombine(superFunc, savegame)
    -- print("--- 5 ------------------------------------------------")
    superFunc(self, savegame)

    local configId = Utils.getNoNil(self.configurations["improvedHarvesterSounds"], 1)
    if configId > 1 then
        if self.baseDirectoryBackup ~= nil then
            self.baseDirectory = self.baseDirectoryBackup
        end
    end
end

function improvedHarvesterSounds:saveToXMLFile(xmlFile, key, usedModNames)
    if self.configurations ~= nil then
        if self.configurations["improvedHarvesterSounds"] ~= nil then
            xmlFile:setValue(key.."#configurationId", self.configurations["improvedHarvesterSounds"])
        end
    end
end

function improvedHarvesterSounds:onPostAttachImplement(object, inputJointDescIndex, jointDescIndex)
    if self.isConfiguredCombine == true then  -- true, if combine and configId > 1
        if object.spec_cutter ~= nil and self.spec_turnOnVehicle ~= nil then
          if self.spec_turnOnVehicle.samples ~= nil and self.spec_turnOnVehicle.samples.work ~= nil and self.spec_turnOnVehicle.samples.work[1] ~= nil then
            if object.spec_cutter.fruitTypes ~= nil and object.spec_cutter.fruitTypes[1] ~= nil then
                if object.spec_cutter.fruitTypes[1] ~= 5 and object.spec_cutter.fruitTypes[1] ~= 6 then  -- no maize and no sunflowers
                    if object.spec_cutter.samples ~= nil then
                        if object.spec_cutter.samples.cut ~= nil then
                            if object.spec_cutter.samples.cut.volumeScale ~= nil then
                                self.saveCutterSampleVolumeScale = object.spec_cutter.samples.cut.volumeScale
                                object.spec_cutter.samples.cut.volumeScale = 0
--                                print("--- 6 ------------------------------------------------")
                            end
                        end
                    end
                else
--                                print("--- 8 ------------------------------------------------")
                    self.saveWork1SampleVolumeScale = self.spec_turnOnVehicle.samples.work[1].volumeScale
                    self.spec_turnOnVehicle.samples.work[1].volumeScale = 0
                end
            end
          end
        end
    end
end
function improvedHarvesterSounds:onPreDetachImplement(implement)
    if self.isConfiguredCombine == true then  -- true, if combine and configId > 1
        if implement.object ~= nil then
            local object = implement.object
            if object.spec_cutter ~= nil then
                if object.spec_cutter.fruitTypes ~= nil and object.spec_cutter.fruitTypes[1] ~= nil then
                    if object.spec_cutter.fruitTypes[1] ~= 5 and object.spec_cutter.fruitTypes[1] ~= 6 then  -- no maize and no sunflowers
                        if self.saveCutterSampleVolumeScale ~= nil then
                            object.spec_cutter.samples.cut.volumeScale = self.saveCutterSampleVolumeScale
                            self.saveCutterSampleVolumeScale = nil
--                            print("--- 7 ------------------------------------------------")
                        end
                    elseif self.saveWork1SampleVolumeScale ~= nil then
                        self.spec_turnOnVehicle.samples.work[1].volumeScale = self.saveWork1SampleVolumeScale
                        self.saveWork1SampleVolumeScale = nil
--                            print("--- 9 ------------------------------------------------")
                    end
                end
            end
        end
    end
end
