-- by modelleicher (Farming Agency)
-- 
-- Version 1.0 for FS19 | 15.12.2018
-- Version 2.0 for FS22 | January 2022


frontloaderAxleLockRemover = {}

function frontloaderAxleLockRemover.prerequisitesPresent(specializations)
    return true
end;

function frontloaderAxleLockRemover.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", frontloaderAxleLockRemover)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", frontloaderAxleLockRemover)
end;

function frontloaderAxleLockRemover:onUpdate(dt)

	if self:getIsActive() and self.spec_frontloaderAxleLockRemover ~= nil then
		local rotLimitBackup = self.spec_frontloaderAxleLockRemover.rotLimitBackup
		local rotLimit = self.componentJoints[self.spec_frontloaderAttacher.frontAxisJoint].rotLimit
		
		if rotLimit[3] ~= rotLimitBackup[3] then
			self:setComponentJointRotLimit(self.componentJoints[self.spec_frontloaderAttacher.frontAxisJoint], 3, -rotLimitBackup[3], rotLimitBackup[3])
		end;			
	end;
	
end;

function frontloaderAxleLockRemover:onLoad(savegame)
	-- only run on SP or server, only run when frontloaderAttacher isn't nil, only run if it has a frontAxisJoint 
	if self.isServer and  self.spec_frontloaderAttacher ~= nil and self.spec_frontloaderAttacher.frontAxisJoint ~= nil then  -- only if FL attacher is there
		self.spec_frontloaderAxleLockRemover = {}
		self.spec_frontloaderAxleLockRemover.rotLimitBackup = {}
		self.spec_frontloaderAxleLockRemover.rotLimitBackup[3] = self.componentJoints[self.spec_frontloaderAttacher.frontAxisJoint].rotLimit[3]					
	end;
end;


