-- Settings Menu
-- Handles the settings page of Exhaust Extension
-- Version 1.0.0.0
-- @author Vector Man
-- @date 2023-09-07
-- copyright (c) Vector Man, All Rights Reserved

ExhaustExtensionMenu = {}

local ExhaustExtensionMenu_mt = Class(ExhaustExtensionMenu)

function ExhaustExtensionMenu:new(mission, i18n, modDirectory, modName)
	local self = setmetatable({}, ExhaustExtensionMenu_mt)
		self.savegameXML = nil
		self.modDescFile = nil
		self.modDirectory = modDirectory
	return self
end

function ExhaustExtensionMenu:onMissionStart(mission)
	if fileExists(g_modSettingsDirectory .. "exhaustExtension.xml") then
		self.savegameXML = loadXMLFile("exhaustExtension", g_modSettingsDirectory .. "exhaustExtension.xml")
	else
		self.savegameXML = createXMLFile("exhaustExtension", g_modSettingsDirectory .. "exhaustExtension.xml", "exhaustExtension")
	end
	
	self.settingValue_disableDefault = getXMLBool(self.savegameXML, "exhaustExtension#disableDefault")
	
	-- set default values if new savegame
	if self.settingValue_disableDefault == nil then
		self.settingValue_disableDefault = false
	end
end

function ExhaustExtensionMenu.initSettingsMenu(self)
    if not self.initializedGui then
        local target = g_exhaustExtensionMenu
		
		-- menu title
		local menuTitle = TextElement.new()
        menuTitle:applyProfile("settingsMenuSubtitle", true)
        menuTitle:setText(g_i18n:getText("menuTitle_ExhaustExtension"))
        self.boxLayout:addElement(menuTitle)
		
		-- setting disableDefault
        self.check_disableDefault = self.checkAutoMotorStart:clone()
        self.check_disableDefault.target = target
        self.check_disableDefault.id = "check_disableDefault"
        self.check_disableDefault:setCallback("onClickCallback", "onSettingsMenuSettingChanged_disableDefault")

        local title = self.check_disableDefault.elements[4]
        local desc = self.check_disableDefault.elements[6]

        title:setText(g_i18n:getText("settingTitle_ExhaustExtensionMenu_disableDefault"))
        desc:setText(g_i18n:getText("settingDesc_ExhaustExtensionMenu_disableDefault"))

        self.check_disableDefault:setIsChecked(g_exhaustExtensionMenu.settingValue_disableDefault)

        self.boxLayout:addElement(self.check_disableDefault)

        self.initializedGui = true
    end
end

function ExhaustExtensionMenu.updateSettingsMenu(self)
	if self.initializedGui then
		if self.check_disableDefault ~= nil then
			self.check_disableDefault:setIsChecked(g_exhaustExtensionMenu.settingValue_disableDefault)
		end
	end
end

function ExhaustExtensionMenu.saveSettings()
	setXMLBool(g_exhaustExtensionMenu.savegameXML, "exhaustExtension#disableDefault", g_exhaustExtensionMenu.settingValue_disableDefault)
	
	saveXMLFile(g_exhaustExtensionMenu.savegameXML)
end

function ExhaustExtensionMenu:onSettingsMenuSettingChanged_disableDefault(state)
	g_exhaustExtensionMenu.settingValue_disableDefault = (state == CheckedOptionElement.STATE_CHECKED)
	g_exhaustExtensionMenu:saveSettings()
end