ColorConfiguratorTextInputElement = {}

local ColorConfiguratorTextInputElement_mt = Class(ColorConfiguratorTextInputElement, TextInputElement)

function ColorConfiguratorTextInputElement.new(target, custom_mt)
	local self = TextInputElement.new(target, custom_mt or ColorConfiguratorTextInputElement_mt)

	self.minValue = 0
	self.maxValue = 255
	self.stepSize = 1
	self.wrapOnScroll = false

	self.changeValueSample = GuiSoundPlayer.SOUND_SAMPLES.HOVER
	self.clickSoundName = GuiSoundPlayer.SOUND_SAMPLES.NONE

	return self
end

function ColorConfiguratorTextInputElement:loadFromXML(xmlFile, key)
	ColorConfiguratorTextInputElement:superClass().loadFromXML(self, xmlFile, key)

	self.minValue = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#minValue"), self.minValue)
	self.maxValue = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#maxValue"), self.maxValue)
	self.stepSize = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#stepSize"), self.stepSize)
	self.wrapOnScroll = Utils.getNoNil(getXMLBool(xmlFile, key .. "#wrapOnScroll"), self.wrapOnScroll)
end

function ColorConfiguratorTextInputElement:loadProfile(profile, applyProfile)
	ColorConfiguratorTextInputElement:superClass().loadProfile(self, profile, applyProfile)

	self.minValue = profile:getNumber("minValue", self.minValue)
	self.maxValue = profile:getNumber("maxValue", self.maxValue)
	self.stepSize = profile:getNumber("stepSize", self.stepSize)
	self.wrapOnScroll = profile:getBool("wrapOnScroll", self.wrapOnScroll)
end

function ColorConfiguratorTextInputElement:setMinMaxValues(minValue, maxValue, stepSize)
	self.minValue = minValue or self.minValue
	self.maxValue = maxValue or self.maxValue
	self.stepSize = stepSize or self.stepSize
end

function ColorConfiguratorTextInputElement:mouseEvent(posX, posY, isDown, isUp, button, eventUsed)
	if self:getIsActive() then
		if ColorConfiguratorTextInputElement:superClass().mouseEvent(self, posX, posY, isDown, isUp, button, eventUsed) then
			eventUsed = true
		end

		if isDown and GuiUtils.checkOverlayOverlap(posX, posY, self.absPosition[1], self.absPosition[2], self.absSize[1], self.absSize[2]) then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				self:changeValue(-self.stepSize)
			elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
				self:changeValue(self.stepSize)
			end

			eventUsed = true
		end
	end

	return eventUsed
end

function ColorConfiguratorTextInputElement:shouldFocusChange(direction)
	local dir1 = FocusManager.LEFT
	local dir2 = FocusManager.RIGHT

	if direction == dir1 then
		self:changeValue(-self.stepSize)

		return false
	elseif direction == dir2 then
		self:changeValue(self.stepSize)

		return false
	end

	return ColorConfiguratorTextInputElement:superClass().shouldFocusChange(self, direction)
end

function ColorConfiguratorTextInputElement:changeValue(stepSize)
	local oldValue = Utils.getNoNil(tonumber(self.text), 0)
	local newValue = oldValue + stepSize

	if self.wrapOnScroll then
		if newValue > self.maxValue then
			newValue = self.minValue
		elseif newValue < self.minValue then
			newValue = self.maxValue
		end
	else
		newValue = MathUtil.clamp(newValue, self.minValue, self.maxValue)
	end

	if oldValue ~= newValue then
		if self.forcePressed then
			self:setForcePressed(false)
		end

		if self:getOverlayState() ~= GuiOverlay.STATE_FOCUSED then
			FocusManager:setFocus(self)
		end

		self:setText(tostring(newValue))
		self:playSample(self.changeValueSample)
	end
end