﻿--[[
Author: Mantrid. Written for Olahaldor
https://fs.mantrid.net/

Copyright: All rights reserved. Permission granted for use by Olahaldor
]]

local modDir = g_currentModDirectory

-- Specific 3rd-party mods, that use base-game i3ds but include their own copy for some unknown reason
local otherModSwaps = {
	{ modName = 'FS22_MaizePlus', modNamePosition = 4 },
	{ modName = 'FS22_Poettinger_200VCProMultiBaler_Mplus', modNamePosition = 3 }
}

local i3dSwaps = {
	{ modName = 'baseGame', origi3d = 'roundbale125.i3d', replacei3d = modDir .. 'assets/roundbale125/roundbale125.i3d' },
	{ modName = 'baseGame', origi3d = 'roundbale150.i3d', replacei3d = modDir .. 'assets/roundbale150/roundbale150.i3d' },
	{ modName = 'baseGame', origi3d = 'roundbale180.i3d', replacei3d = modDir .. 'assets/roundbale180/roundbale180.i3d' },

	{ modName = 'FS22_MaizePlus', origi3d = 'roundbale125.i3d', replacei3d = modDir .. 'assets/roundbale125/roundbale125.i3d' },
	{ modName = 'FS22_MaizePlus', origi3d = 'roundbale150.i3d', replacei3d = modDir .. 'assets/roundbale150/roundbale150.i3d' },
	{ modName = 'FS22_MaizePlus', origi3d = 'roundbale180.i3d', replacei3d = modDir .. 'assets/roundbale180/roundbale180.i3d' },

	{ modName = 'FS22_MaizePlus', origi3d = 'CM_roundbale125.i3d', replacei3d = modDir .. 'assets/roundbale125/CM_roundbale125.i3d' },
	{ modName = 'FS22_MaizePlus', origi3d = 'CM_roundbale150.i3d', replacei3d = modDir .. 'assets/roundbale150/CM_roundbale150.i3d' },
	{ modName = 'FS22_MaizePlus', origi3d = 'CM_roundbale180.i3d', replacei3d = modDir .. 'assets/roundbale180/CM_roundbale180.i3d' },

	{ modName = 'FS22_Poettinger_200VCProMultiBaler_Mplus', origi3d = 'roundbale125.i3d', replacei3d = modDir .. 'assets/roundbale125/CM_roundbale125.i3d' },
	{ modName = 'FS22_Poettinger_200VCProMultiBaler_Mplus', origi3d = 'roundbale150.i3d', replacei3d = modDir .. 'assets/roundbale150/CM_roundbale150.i3d' }
}

BaleSwapper = {}

-- Swap our i3d in
function BaleSwapper.insteadOf_createNode(self, superFunc, i3dFilename)
	-- Split the path up
	local pathBits = i3dFilename:split("/")
	
	-- Detect base-game
	if pathBits[1] == 'data' then
		-- Base-game bale
		for _, swap in ipairs(i3dSwaps) do
			if swap.modName == 'baseGame' then
				if swap.origi3d == pathBits[#pathBits] then
					i3dFilename = swap.replacei3d
				end
			end
		end
	else -- Look for other known mods
		for _, otherMod in ipairs(otherModSwaps) do
			if #pathBits > otherMod.modNamePosition then
				if pathBits[#pathBits - otherMod.modNamePosition] == otherMod.modName then
					-- We found a known mod
					for _, swap in ipairs(i3dSwaps) do
						if swap.modName == otherMod.modName then
							-- Swap our i3d in, if we have a custom one
							if swap.origi3d == pathBits[#pathBits] then
								i3dFilename = swap.replacei3d
							end
						end
					end
				end
			end
		end
	end
	
	self.i3dFilename = i3dFilename

	local baleRoot, sharedLoadRequestId = g_i3DManager:loadSharedI3DFile(i3dFilename, false, false)
	self.sharedLoadRequestId = sharedLoadRequestId
	local baleId = getChildAt(baleRoot, 0)

	link(getRootNode(), baleId)
	delete(baleRoot)
	self:setNodeId(baleId)
end
