-- Name: EAS_UpdateOvercrowdingStateEvent
-- Author: Chissel

EAS_UpdateOvercrowdingStateEvent = {}

local EAS_UpdateOvercrowdingStateEvent_mt = Class(EAS_UpdateOvercrowdingStateEvent, Event)
InitEventClass(EAS_UpdateOvercrowdingStateEvent, "EAS_UpdateOvercrowdingStateEvent")

function EAS_UpdateOvercrowdingStateEvent.emptyNew()
    local self = Event.new(EAS_UpdateOvercrowdingStateEvent_mt)

    return self
end

function EAS_UpdateOvercrowdingStateEvent.new(husbandry, state)
    local self = EAS_UpdateOvercrowdingStateEvent.emptyNew()

    self.husbandry = husbandry
    self.state = state

    return self
end

function EAS_UpdateOvercrowdingStateEvent:readStream(streamId, connection)
    g_easUtils:logText("EAS_UpdateOvercrowdingStateEvent readStream")
    self.husbandry = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadBool(streamId)

    self:run(connection)
end

function EAS_UpdateOvercrowdingStateEvent:writeStream(streamId, connection)
    g_easUtils:logText("EAS_UpdateOvercrowdingStateEvent writeStream")
    NetworkUtil.writeNodeObject(streamId, self.husbandry)
    streamWriteBool(streamId, self.state)
end

function EAS_UpdateOvercrowdingStateEvent:run(connection)
    self.husbandry.spec_husbandryAnimals.allowOvercrowding = self.state

    if not connection:getIsServer() then
        g_server:broadcastEvent(EAS_UpdateOvercrowdingStateEvent.new(self.husbandry, self.state), false)
    end
end
