-- Name: EAS_RemoveMoneyEvent
-- Author: Chissel

EAS_RemoveMoneyEvent = {}

local EAS_RemoveMoneyEvent_mt = Class(EAS_RemoveMoneyEvent, Event)
InitEventClass(EAS_RemoveMoneyEvent, "EAS_RemoveMoneyEvent")

function EAS_RemoveMoneyEvent.emptyNew()
    local self = Event.new(EAS_RemoveMoneyEvent_mt)

    return self
end

function EAS_RemoveMoneyEvent.new(farmId, amount, moneyType)
    local self = EAS_RemoveMoneyEvent.emptyNew()

    self.farmId = farmId
    self.amount = amount
    self.moneyType = moneyType

    return self
end

function EAS_RemoveMoneyEvent:readStream(streamId, connection)
    self.farmId = streamReadInt32(streamId)
    self.amount = streamReadFloat32(streamId)
	local moneyTypeId = streamReadUInt16(streamId)
	self.moneyType = MoneyType.getMoneyTypeById(moneyTypeId)

    self:run(connection)
end

function EAS_RemoveMoneyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.farmId)
    streamWriteFloat32(streamId, self.amount)
	streamWriteUInt16(streamId, self.moneyType.id)
end

function EAS_RemoveMoneyEvent:run(connection)
    if not connection:getIsServer() then
        g_currentMission:addMoneyChange(-self.amount, self.farmId, self.moneyType, true)

        local farm = g_farmManager:getFarmById(self.farmId)
        if farm ~= nil then
            farm:changeBalance(-self.amount, self.moneyType)
        end
    end
end