-- Name: EAS_Utils
-- Author: Chissel

EAS_Utils = {}
EAS_Utils.__index = EAS_Utils
EAS_Utils.DebuggerMode = false
EAS_Utils.Settings = {}

setmetatable(EAS_Utils, {
  __call = function (cls, ...)
  local self = setmetatable({}, cls)

  self:new(...)

  return self
  end,
})

function EAS_Utils:new()
    if EAS_Utils.DebuggerMode then
       EAS_Utils:logText("Debug mode is active")
    end
end

function EAS_Utils.loadXml()
	local path = g_currentModDirectory .. "xml/eas_settings.xml"
	local key = "EnhancedAnimalSystem.Settings"
	local xmlFileId = loadXMLFile("EAS_Utils", path)

	EAS_Utils.Settings.SellingPricePercentage = getXMLFloat(xmlFileId, key.."#SellingPricePercentage")
	EAS_Utils.Settings.MaxOvercrowdingPercentage = getXMLFloat(xmlFileId, key.."#MaxOvercrowdingPercentage")
	EAS_Utils.Settings.AnimalDiedPercentageOnMaxAge = getXMLInt(xmlFileId, key.."#AnimalDiedPercentageOnMaxAge")
	EAS_Utils.Settings.AnimalDiedPercentageWhenHealthIsEmpty = getXMLInt(xmlFileId, key.."#AnimalDiedPercentageWhenHealthIsEmpty")
	EAS_Utils.Settings.NumHoursOfOvercrowdingBeforReduceHealth = getXMLInt(xmlFileId, key.."#NumHoursOfOvercrowdingBeforReduceHealth")
	EAS_Utils.Settings.MaxHealthOvercrowdingDeduction = getXMLInt(xmlFileId, key.."#MaxHealthOvercrowdingDeduction")
	
	EAS_Utils.Settings.MinPiglets = getXMLInt(xmlFileId, key.."#MinPiglets")
	EAS_Utils.Settings.MaxPiglets = getXMLInt(xmlFileId, key.."#MaxPiglets")
	EAS_Utils.Settings.PigMaxAge = getXMLInt(xmlFileId, key.."#PigMaxAge")
	EAS_Utils.Settings.PigInseminationCost = getXMLInt(xmlFileId, key.."#PigInseminationCost")

	EAS_Utils.Settings.MinCalfs = getXMLInt(xmlFileId, key.."#MinCalfs")
	EAS_Utils.Settings.MaxCalfs = getXMLInt(xmlFileId, key.."#MaxCalfs")
	EAS_Utils.Settings.CowMaxAge = getXMLInt(xmlFileId, key.."#CowMaxAge")
	EAS_Utils.Settings.CowInseminationCost = getXMLInt(xmlFileId, key.."#CowInseminationCost")

	EAS_Utils.Settings.MinFoals = getXMLInt(xmlFileId, key.."#MinFoals")
	EAS_Utils.Settings.MaxFoals = getXMLInt(xmlFileId, key.."#MaxFoals")
	EAS_Utils.Settings.HorseMaxAge = getXMLInt(xmlFileId, key.."#HorseMaxAge")
	EAS_Utils.Settings.HorseInseminationCost = getXMLInt(xmlFileId, key.."#HorseInseminationCost")

	EAS_Utils.Settings.MinLambs = getXMLInt(xmlFileId, key.."#MinLambs")
	EAS_Utils.Settings.MaxLambs = getXMLInt(xmlFileId, key.."#MaxLambs")
	EAS_Utils.Settings.SheepMaxAge = getXMLInt(xmlFileId, key.."#SheepMaxAge")
	EAS_Utils.Settings.SheepInseminationCost = getXMLInt(xmlFileId, key.."#SheepInseminationCost")

	EAS_Utils.Settings.MinChickens = getXMLInt(xmlFileId, key.."#MinChickens")
	EAS_Utils.Settings.MaxChickens = getXMLInt(xmlFileId, key.."#MaxChickens")
	EAS_Utils.Settings.ChickenMaxAge = getXMLInt(xmlFileId, key.."#ChickenMaxAge")
	EAS_Utils.Settings.ChickenInseminationCost = getXMLInt(xmlFileId, key.."#ChickenInseminationCost")

	local pigletsProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#PigletsProbabilities"))
    EAS_Utils.Settings.PigletProbabilities = EAS_Utils.createProbabilityTable(pigletsProbabilities, EAS_Utils.Settings.MinPiglets)
	local calfProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#CalfProbabilities"))
    EAS_Utils.Settings.CalfProbabilities = EAS_Utils.createProbabilityTable(calfProbabilities, EAS_Utils.Settings.MinCalfs)
	local foalProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#FoalProbabilities"))
    EAS_Utils.Settings.FoalProbabilities = EAS_Utils.createProbabilityTable(foalProbabilities, EAS_Utils.Settings.MinFoals)
	local lambProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#LambProbabilities"))
    EAS_Utils.Settings.LambProbabilities = EAS_Utils.createProbabilityTable(lambProbabilities, EAS_Utils.Settings.MinLambs)
	local chickenProbabilities =  EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#ChickenProbabilities"))
    EAS_Utils.Settings.ChickenProbabilities = EAS_Utils.createProbabilityTable(chickenProbabilities, EAS_Utils.Settings.MinChickens)

    EAS_Utils.Settings.PigInseminationProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#PigInseminationProbabilities"))
    EAS_Utils.Settings.CowInseminationProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#CowInseminationProbabilities"))
    EAS_Utils.Settings.HorseInseminationProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#HorseInseminationProbabilities"))
    EAS_Utils.Settings.SheepInseminationProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#SheepInseminationProbabilities"))
    EAS_Utils.Settings.ChickenInseminationProbabilities = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#ChickenInseminationProbabilities"))

    EAS_Utils.Settings.PigFoodFactor = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#PigFoodFactor"))
	EAS_Utils.Settings.CowFoodFactor = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#CowFoodFactor"))
	EAS_Utils.Settings.HorseFoodFactor = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#HorseFoodFactor"))
	EAS_Utils.Settings.SheepFoodFactor = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#SheepFoodFactor"))
	EAS_Utils.Settings.ChickenFoodFactor = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#ChickenFoodFactor"))
	
    EAS_Utils.Settings.CowLactation = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#CowLactation"))
	EAS_Utils.Settings.GoatLactation = EAS_Utils.sliceByKomma(getXMLString(xmlFileId, key.."#GoatLactation"))
	
	if EAS_Utils.DebuggerMode then
        EAS_Utils:logText("Load settings xml")
		
		for k,v in pairs(EAS_Utils.Settings) do
			print(tostring(k)..": "..tostring(v))
		end
	end

    return EAS_Utils.Settings
end

function EAS_Utils.createProbabilityTable(values, minValue)
    local probabilities = {}
    for index, value in pairs(values) do
        EAS_Utils.insertXTimes(minValue + (index - 1), value, probabilities)
    end
    return probabilities
end

function EAS_Utils.insertXTimes(value, times, mutableTable)
    for i=1, times do
        table.insert(mutableTable, value)
    end
end

function EAS_Utils.sliceByKomma(text)
    local values = {}
    for value in text:gmatch('[^,%s]+') do
        table.insert(values, value)
    end
    return values
end

function EAS_Utils:hasItem(array, item)
    for _, value in ipairs(array) do
        if value == item then
            return true
        end
    end

    return false
end

function EAS_Utils:removeItemFromTable(item, array)
    for index, value in ipairs(array) do
        if value == item then
            table.remove(array, index)
            break
        end
    end
end

function EAS_Utils:deepcopy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[EAS_Utils:deepcopy(orig_key)] = EAS_Utils:deepcopy(orig_value)
        end
        setmetatable(copy, EAS_Utils:deepcopy(getmetatable(orig)))
    else
        copy = orig
    end
    return copy
end

function EAS_Utils:rpairs(t)
	return function(t, i)
		i = i - 1
		if i ~= 0 then
			return i, t[i]
		end
	end, t, #t + 1
end


function EAS_Utils:logText(text)
	if EAS_Utils.DebuggerMode then
        local prefix = "------------------------------------------------ EnhancedAnimalSystem ------------------------------------------------"
        print(prefix, text)
    end
end