-- Name: EAS_PlaceableHusbandryMilkExtension
-- Author: Chissel

EAS_PlaceableHusbandryMilkExtension = {}

function EAS_PlaceableHusbandryMilkExtension.onHusbandryAnimalsUpdate(self, superFunc, clusters)
	local spec = self.spec_husbandryMilk
	spec.litersPerHour = 0

	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)

		if subType ~= nil then
			local milk = subType.output.milk

			if milk ~= nil and cluster.reproduction < 80 and cluster.hadABirth then
				local age = cluster:getAge()
				local litersPerAnimals = milk:get(age)
				local litersPerDay = litersPerAnimals * cluster:getNumAnimals()

				local lactationFactor = 0.0
				if cluster.monthsSinceLastBirth < #EAS_Utils.Settings.CowLactation then
					lactationFactor = tonumber(EAS_Utils.Settings.CowLactation[cluster.monthsSinceLastBirth + 1])
				end

				local litersPerHourWithLactation = (litersPerDay / 24) * lactationFactor
				spec.litersPerHour = spec.litersPerHour + litersPerHourWithLactation
			end
		end
	end
end

PlaceableHusbandryMilk.onHusbandryAnimalsUpdate = Utils.overwrittenFunction(PlaceableHusbandryMilk.onHusbandryAnimalsUpdate, EAS_PlaceableHusbandryMilkExtension.onHusbandryAnimalsUpdate)