-- Name: EAS_PlaceableHusbandryGoatMilk
-- Author: Chissel

EAS_PlaceableHusbandryGoatMilk = {}
EAS_PlaceableHusbandryGoatMilk.currentModName = g_currentModName

source("dataS/scripts/animals/husbandry/objects/MilkingRobot.lua")

function EAS_PlaceableHusbandryGoatMilk.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(PlaceableHusbandry, specializations)
end


function EAS_PlaceableHusbandryGoatMilk.registerFunctions(placeableType)
	SpecializationUtil.registerFunction(placeableType, "onMilkingRobotLoaded", EAS_PlaceableHusbandryGoatMilk.onMilkingRobotLoaded)
end

function EAS_PlaceableHusbandryGoatMilk.registerOverwrittenFunctions(placeableType)
	SpecializationUtil.registerOverwrittenFunction(placeableType, "updateOutput", EAS_PlaceableHusbandryGoatMilk.updateOutput)
	SpecializationUtil.registerOverwrittenFunction(placeableType, "updateInfo", EAS_PlaceableHusbandryGoatMilk.updateInfo)
	SpecializationUtil.registerOverwrittenFunction(placeableType, "getConditionInfos", EAS_PlaceableHusbandryGoatMilk.getConditionInfos)
end

function EAS_PlaceableHusbandryGoatMilk.registerEventListeners(placeableType)
	SpecializationUtil.registerEventListener(placeableType, "onLoad", EAS_PlaceableHusbandryGoatMilk)
	SpecializationUtil.registerEventListener(placeableType, "onDelete", EAS_PlaceableHusbandryGoatMilk)
	SpecializationUtil.registerEventListener(placeableType, "onFinalizePlacement", EAS_PlaceableHusbandryGoatMilk)
	SpecializationUtil.registerEventListener(placeableType, "onHusbandryAnimalsUpdate", EAS_PlaceableHusbandryGoatMilk)
end

function EAS_PlaceableHusbandryGoatMilk.registerXMLPaths(schema, basePath)
	schema:setXMLSpecializationType("Husbandry")

	basePath = basePath .. ".husbandry.goatmilk"

	schema:register(XMLValueType.NODE_INDEX, basePath .. ".milkingRobots.milkingRobot(?)#linkNode", "Milkingrobot link node")
	schema:register(XMLValueType.STRING, basePath .. ".milkingRobots.milkingRobot(?)#class", "Milkingrobot class name")
	schema:register(XMLValueType.STRING, basePath .. ".milkingRobots.milkingRobot(?)#filename", "Milkingrobot config file")
	schema:setXMLSpecializationType()
end

function EAS_PlaceableHusbandryGoatMilk:onLoad(savegame)
    if self.spec_husbandry.storage == nil or
        self.spec_husbandry.storage.capacities[FillType.GOATMILK] == nil
    then
        self.eas_isGoatMilkSupported = false
        return
    else
        self.eas_isGoatMilkSupported = true
    end

	self.spec_husbandryGoatMilk = {}
	local spec = self.spec_husbandryGoatMilk
	spec.litersPerHour = 0
	spec.fillType = FillType.GOATMILK
	spec.info = {
		text = "",
		title = g_i18n:getText("fillType_goatmilk")
	}
	spec.milkingRobots = {}
	spec.husbandry = nil

	self.xmlFile:iterate("placeable.husbandry.goatmilk.milkingRobots.milkingRobot", function (_, key)
		local filename = Utils.getFilename(self.xmlFile:getValue(key .. "#filename", nil), self.baseDirectory)

		if filename == nil then
			Logging.xmlWarning(self.xmlFile, "Milkingrobot filename missing for '%s'", key)

			return
		end

		local className = self.xmlFile:getValue(key .. "#class", "")
		local class = ClassUtil.getClassObject(className)

		if class == nil then
			Logging.xmlWarning(self.xmlFile, "Milkingrobot class '%s' not defined for '%s'", className, key)

			return
		end

		local linkNode = self.xmlFile:getValue(key .. "#linkNode", nil, self.components, self.i3dMappings)

		if linkNode == nil then
			Logging.xmlWarning(self.xmlFile, "Milkingrobot linkNode not defined for '%s'", key)

			return
		end

		local loadingTask = self:createLoadingTask(self)
		local robot = class.new(self, self.baseDirectory)

		robot:load(linkNode, filename, self.onMilkingRobotLoaded, self, {
			loadingTask
		})
		table.insert(spec.milkingRobots, robot)
	end)
end

function EAS_PlaceableHusbandryGoatMilk:onMilkingRobotLoaded(robot, args)
	local task = unpack(args)

	self:finishLoadingTask(task)
end

function EAS_PlaceableHusbandryGoatMilk:onDelete()
    if not self.eas_isGoatMilkSupported then
        return
    end

	local spec = self.spec_husbandryGoatMilk

	if spec.milkingRobots ~= nil then
		for _, robot in ipairs(spec.milkingRobots) do
			robot:delete()
		end

		spec.milkingRobots = {}
	end
end

function EAS_PlaceableHusbandryGoatMilk:onFinalizePlacement()
    if not self.eas_isGoatMilkSupported then
        return
    end

	local spec = self.spec_husbandryGoatMilk

	if not self:getHusbandryIsFillTypeSupported(spec.fillType) then
		Logging.warning("Missing filltype 'goatmilk' in husbandry storage!")
	end

	for _, robot in ipairs(spec.milkingRobots) do
		robot:finalizePlacement()
	end
end

function EAS_PlaceableHusbandryGoatMilk:updateOutput(superFunc, foodFactor, productionFactor, globalProductionFactor)
	if not self.eas_isGoatMilkSupported then
        superFunc(self, foodFactor, productionFactor, globalProductionFactor)
        return
    end

    local spec = self.spec_husbandryGoatMilk

	if self.isServer and spec.litersPerHour > 0 then
		local liters = productionFactor * globalProductionFactor * spec.litersPerHour * g_currentMission.environment.timeAdjustment

        local freeCapacity = self:getHusbandryFreeCapacity(spec.fillType)

        if freeCapacity < liters then
            liters = freeCapacity
        end

		self:addHusbandryFillLevelFromTool(self:getOwnerFarmId(), liters, spec.fillType, nil, nil, nil)
	end

	superFunc(self, foodFactor, productionFactor, globalProductionFactor)
end

function EAS_PlaceableHusbandryGoatMilk:onHusbandryAnimalsUpdate(clusters)
	if not self.eas_isGoatMilkSupported then
        return
    end

    local spec = self.spec_husbandryGoatMilk
	spec.litersPerHour = 0

	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)

		if subType ~= nil then
			local milk = subType.output.milk

			if milk ~= nil and cluster.reproduction < 80 and cluster.hadABirth then
				local age = cluster:getAge()
				local litersPerAnimals = milk:get(age)
				local litersPerDay = litersPerAnimals * cluster:getNumAnimals()

				local lactationFactor = 0.0
				if cluster.monthsSinceLastBirth < #EAS_Utils.Settings.GoatLactation then
					lactationFactor = tonumber(EAS_Utils.Settings.GoatLactation[cluster.monthsSinceLastBirth + 1])
				end

				local litersPerHourWithLactation = (litersPerDay / 24) * lactationFactor

				spec.litersPerHour = spec.litersPerHour + litersPerHourWithLactation
			end
		end
	end
end

function EAS_PlaceableHusbandryGoatMilk:updateInfo(superFunc, infoTable)
	if not self.eas_isGoatMilkSupported then
        superFunc(self, infoTable)
        return
    end

    local spec = self.spec_husbandryGoatMilk

	superFunc(self, infoTable)

	local fillLevel = self:getHusbandryFillLevel(spec.fillType)
	spec.info.text = string.format("%d l", fillLevel)

	table.insert(infoTable, spec.info)
end

function EAS_PlaceableHusbandryGoatMilk:getConditionInfos(superFunc)
	if not self.eas_isGoatMilkSupported then
        local infos = superFunc(self)
        return infos
    end

    local spec = self.spec_husbandryGoatMilk
	local infos = superFunc(self)
	local info = {}
	local fillType = g_fillTypeManager:getFillTypeByIndex(spec.fillType)
	info.title = fillType.title
	info.value = self:getHusbandryFillLevel(spec.fillType)
	local capacity = self:getHusbandryCapacity(spec.fillType)
	local ratio = 0

	if capacity > 0 then
		ratio = info.value / capacity
	end

	info.ratio = MathUtil.clamp(ratio, 0, 1)
	info.invertedBar = true

	table.insert(infos, info)

	return infos
end
