-- Name: EAS_PlaceableHusbandryFoodExtension
-- Author: Chissel

EAS_PlaceableHusbandryFoodExtension = {}

function EAS_PlaceableHusbandryFoodExtension:onHusbandryAnimalsUpdate(superFunc, clusters)
	local spec = self.spec_husbandryFood
	spec.litersPerHour = 0

	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)

		if subType ~= nil then
			local food = subType.input.food

			if food ~= nil then
				local age = cluster:getAge()
				local litersPerAnimal = food:get(age)
				local litersPerDay = litersPerAnimal * cluster:getNumAnimals()

                local foodFactor = EAS_AnimalClusterExtension.lactationFactorForAnimalType(subType.typeIndex, cluster)
                local litersPerHourWithFoodFactor = (litersPerDay / 24) * foodFactor

				spec.litersPerHour = spec.litersPerHour + litersPerHourWithFoodFactor
			end
		end
	end
end

PlaceableHusbandryFood.onHusbandryAnimalsUpdate = Utils.overwrittenFunction(PlaceableHusbandryFood.onHusbandryAnimalsUpdate, EAS_PlaceableHusbandryFoodExtension.onHusbandryAnimalsUpdate)

function EAS_AnimalClusterExtension.lactationFactorForAnimalType(subTypeIndex, cluster)
    local animalType = g_currentMission.animalSystem:getTypeByIndex(subTypeIndex)
    local animalTypeIndex = animalType.typeIndex
    local foodFactor = 1.0
    local values = {}
    if animalTypeIndex == AnimalType.PIG then
        values = EnhancedAnimalSystem.Settings.PigFoodFactor
    elseif animalTypeIndex == AnimalType.COW then
        values = EnhancedAnimalSystem.Settings.CowFoodFactor
    elseif animalTypeIndex == AnimalType.HORSE then
        values = EnhancedAnimalSystem.Settings.HorseFoodFactor
    elseif animalTypeIndex == AnimalType.SHEEP then
        values = EnhancedAnimalSystem.Settings.SheepFoodFactor
    elseif animalTypeIndex == AnimalType.CHICKEN then
        values = EnhancedAnimalSystem.Settings.ChickenFoodFactor
    end

    if cluster:getCanReproduce() and cluster.hadABirth and cluster.monthsSinceLastBirth < #values then
        foodFactor = values[cluster.monthsSinceLastBirth + 1]
    end

    return foodFactor
end