-- Name: EAS_LoadFillTypes
-- Author: Chissel

EAS_LoadFillTypes = {}

local modDirectory = g_currentModDirectory
local modName = g_currentModName

function EAS_LoadFillTypes.loadFillTypesFromXML(xmlFile, missionInfo, baseDirectory)
    local hofBergmannMap = g_modManager:getModByName("FS22_HofBergmann")
    if hofBergmannMap ~= nil and g_modIsLoaded["FS22_HofBergmann"] then
        local fillTypesXML = loadXMLFile("EAS_fillTypes", modDirectory.."xml/hof_bergmann_fillTypes.xml")
        g_fillTypeManager:loadFillTypes(fillTypesXML, modDirectory , false, modName)
    else
        local fillTypesXML = loadXMLFile("EAS_fillTypes", modDirectory.."xml/eas_fillTypes.xml")
        g_fillTypeManager:loadFillTypes(fillTypesXML, modDirectory , false, modName)
    end
end

FillTypeManager.loadMapData = Utils.appendedFunction(FillTypeManager.loadMapData, EAS_LoadFillTypes.loadFillTypesFromXML)