-- Name: EAS_AnimalsMenuExtension
-- Author: Chissel

local modDirectory = g_currentModDirectory

EAS_AnimalsMenuExtension = {}

function EAS_AnimalsMenuExtension:init()
    g_easUtils:logText("EAS_AnimalsMenuExtension created")

    InGameMenuAnimalsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuAnimalsFrame.onFrameOpen, EAS_AnimalsMenuExtension.onFrameOpen)
    InGameMenuAnimalsFrame.onFrameClose = Utils.appendedFunction(InGameMenuAnimalsFrame.onFrameClose, EAS_AnimalsMenuExtension.onFrameClose)
    InGameMenuAnimalsFrame.onListSelectionChanged = Utils.appendedFunction(InGameMenuAnimalsFrame.onListSelectionChanged, EAS_AnimalsMenuExtension.onListSelectionChanged)
end

function EAS_AnimalsMenuExtension:onFrameOpen()
    local selectedHusbandry = g_currentMission.inGameMenu.pageAnimals.selectedHusbandry

    if self.numberOfInseminationDialog == nil then
        self.numberOfInseminationDialog = EAS_NumberPickerDialog.new(self, nil, self.i18n)
        g_gui:loadGui(modDirectory .. "gui/EAS_NumberPickerDialog.xml", "EAS_NumberPickerDialog", self.numberOfInseminationDialog)
    end

    if selectedHusbandry == nil then
        return
    end

    g_easUtils:logText("onFrameOpen")
    local inGameMenu = g_currentMission.inGameMenu

    if inGameMenu.overcrowdingButton == nil then
        local parent = inGameMenu.menuButton[1].parent
		inGameMenu.overcrowdingButton = inGameMenu.menuButton[1]:clone(parent)
		inGameMenu.overcrowdingButton.onClickCallback = EAS_AnimalsMenuExtension.onOvercrowdingButtonClicked
		inGameMenu.overcrowdingButton:setText(g_i18n:getText("EAS_AllowOvercrowding"))
		inGameMenu.overcrowdingButton:setInputAction("MENU_EXTRA_1")
        inGameMenu.menuButton[1].parent:addElement(inGameMenu.overcrowdingButton)
	end

    if inGameMenu.automaticInsemination == nil then
        local parent = inGameMenu.menuButton[1].parent
		inGameMenu.automaticInsemination = inGameMenu.menuButton[1]:clone(parent)
		inGameMenu.automaticInsemination.onClickCallback = EAS_AnimalsMenuExtension.onAutomaticInseminationClicked
		inGameMenu.automaticInsemination:setText(g_i18n:getText("EAS_AutomaticInsemination_On"))
		inGameMenu.automaticInsemination:setInputAction("MENU_EXTRA_2")
        inGameMenu.menuButton[1].parent:addElement(inGameMenu.automaticInsemination)
	end

    if inGameMenu.manualInsemination == nil then
        local parent = inGameMenu.menuButton[1].parent
		inGameMenu.manualInsemination = inGameMenu.menuButton[1]:clone(parent)
		inGameMenu.manualInsemination.onClickCallback = EAS_AnimalsMenuExtension.onManualInseminationClicked
		inGameMenu.manualInsemination:setText(g_i18n:getText("EAS_ManualInsemination"))
		inGameMenu.manualInsemination:setInputAction("MENU_ACCEPT")
        inGameMenu.menuButton[1].parent:addElement(inGameMenu.manualInsemination)
	end

    if inGameMenu.pageAnimals.monthsSinceLastBirth == nil then
        local parent = inGameMenu.pageAnimals.animalAgeText.parent
		inGameMenu.pageAnimals.monthsSinceLastBirth = inGameMenu.pageAnimals.animalAgeText:clone(parent)
		inGameMenu.pageAnimals.monthsSinceLastBirth:setText(EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText())
        inGameMenu.pageAnimals.infoRow[1].parent:addElement(inGameMenu.pageAnimals.monthsSinceLastBirth)
	end

    EAS_AnimalsMenuExtension.updateButtons()
    self.animalDataUpdateTime = 0
end

function EAS_AnimalsMenuExtension:onFrameClose()
    g_easUtils:logText("onFrameClose")

    local inGameMenu = g_currentMission.inGameMenu

    if inGameMenu.overcrowdingButton ~= nil then
        inGameMenu.overcrowdingButton:unlinkElement()
        inGameMenu.overcrowdingButton:delete()
        inGameMenu.overcrowdingButton = nil
    end

    if inGameMenu.automaticInsemination ~= nil then
        inGameMenu.automaticInsemination:unlinkElement()
        inGameMenu.automaticInsemination:delete()
        inGameMenu.automaticInsemination = nil
    end

    if inGameMenu.manualInsemination ~= nil then
        inGameMenu.manualInsemination:unlinkElement()
        inGameMenu.manualInsemination:delete()
        inGameMenu.manualInsemination = nil
    end
end

function EAS_AnimalsMenuExtension:onListSelectionChanged()
    g_easUtils:logText("onListSelectionChanged")
    EAS_AnimalsMenuExtension.updateButtons()
    EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
end

-- ################################# Delegates ####################################

function EAS_AnimalsMenuExtension.onOvercrowdingButtonClicked(dialog)
    local selectedHusbandry = g_currentMission.inGameMenu.pageAnimals.selectedHusbandry
    local allowOvercrowding = selectedHusbandry.spec_husbandryAnimals.allowOvercrowding

    if allowOvercrowding then
        allowOvercrowding = false
    else
        allowOvercrowding = true
    end

    selectedHusbandry.spec_husbandryAnimals.allowOvercrowding = allowOvercrowding
    g_client:getServerConnection():sendEvent(EAS_UpdateOvercrowdingStateEvent.new(selectedHusbandry, allowOvercrowding))

    EAS_AnimalsMenuExtension.updateButtons()
end

function EAS_AnimalsMenuExtension.onAutomaticInseminationClicked(dialog)
    local selectedHusbandry = g_currentMission.inGameMenu.pageAnimals.selectedHusbandry
    local automaticInsemination = selectedHusbandry.spec_husbandryAnimals.automaticInsemination

    if automaticInsemination then
        automaticInsemination = false
    else
        automaticInsemination = true
    end

    selectedHusbandry.spec_husbandryAnimals.automaticInsemination = automaticInsemination
    g_client:getServerConnection():sendEvent(EAS_UpdateAutomaticInseminationStateEvent.new(selectedHusbandry, automaticInsemination))

    EAS_AnimalsMenuExtension.updateButtons()
end

function EAS_AnimalsMenuExtension.onManualInseminationClicked(dialog)
    EAS_AnimalsMenuExtension.showManualInseminationDialog()
end

function EAS_AnimalsMenuExtension.showManualInseminationDialog()
    local dialog = g_gui.guis.EAS_NumberPickerDialog

    if dialog ~= nil then
        local target = dialog.target
        local selectedCluster = g_currentMission.inGameMenu.pageAnimals.selectedCluster

        target:setCallback(EAS_AnimalsMenuExtension.manualInseminationCallback, EAS_AnimalsMenuExtension)
        target:setMaxNumAnimals(selectedCluster.numAnimals)

        g_gui:showDialog("EAS_NumberPickerDialog")
    end
end

function EAS_AnimalsMenuExtension.manualInseminationCallback(dialog, numberOfInsemination, success)
    if success then
        local selectedCluster = g_currentMission.inGameMenu.pageAnimals.selectedCluster
        local selectedHusbandry = g_currentMission.inGameMenu.pageAnimals.selectedHusbandry
        EnhancedAnimalSystem.collectInseminationCost(selectedHusbandry.spec_husbandryAnimals, numberOfInsemination)
        g_client:getServerConnection():sendEvent(EAS_InseminateClusterEvent.new(selectedHusbandry, selectedCluster.id, numberOfInsemination))
    end
end

-- ################################# Update buttons ####################################

function EAS_AnimalsMenuExtension.updateButtons()
    local inGameMenu = g_currentMission.inGameMenu
    local selectedHusbandry = g_currentMission.inGameMenu.pageAnimals.selectedHusbandry
    local selectedCluster = g_currentMission.inGameMenu.pageAnimals.selectedCluster

    if selectedHusbandry == nil then
        return
    end

    if inGameMenu.overcrowdingButton ~= nil then
        EAS_AnimalsMenuExtension.updateOvercrowdingButton(inGameMenu.overcrowdingButton, selectedHusbandry.spec_husbandryAnimals.allowOvercrowding)
    end

    if inGameMenu.automaticInsemination ~= nil then
        EAS_AnimalsMenuExtension.updateAutomaticInseminationButton(inGameMenu.automaticInsemination, selectedHusbandry.spec_husbandryAnimals.automaticInsemination)
    end

    if inGameMenu.manualInsemination ~= nil then
        local subType = g_currentMission.animalSystem:getSubTypeByIndex(selectedCluster:getSubTypeIndex())
        local isManualInseminationDisabled = selectedHusbandry.spec_husbandryAnimals.automaticInsemination or selectedCluster.isInseminated or subType.reproductionMinAgeMonth > selectedCluster.age or not subType.supportsReproduction
        EAS_AnimalsMenuExtension.updateManualInseminationButton(inGameMenu.manualInsemination, isManualInseminationDisabled)
    end
end

function EAS_AnimalsMenuExtension.updateOvercrowdingButton(button, allowOvercrowding)
    if allowOvercrowding then
        button:setText(g_i18n:getText("EAS_PreventOvercrowding"))
    else
        button:setText(g_i18n:getText("EAS_AllowOvercrowding"))
    end

    g_easUtils:logText("Update overcrowding button")
end

function EAS_AnimalsMenuExtension.updateAutomaticInseminationButton(button, automaticInsemination)
    if automaticInsemination then
        button:setText(g_i18n:getText("EAS_AutomaticInsemination_Off"))
    else
        button:setText(g_i18n:getText("EAS_AutomaticInsemination_On"))
    end
end

function EAS_AnimalsMenuExtension.updateManualInseminationButton(button, manualInsemination)
    button:setDisabled(manualInsemination)
end

-- ################################# Update month since last birth ####################################

function EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
    local inGameMenu = g_currentMission.inGameMenu
    if inGameMenu.pageAnimals.monthsSinceLastBirth == nil then
        return
    end

    inGameMenu.pageAnimals.monthsSinceLastBirth:setText(EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText())
end

function EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText()
    local selectedCluster = g_currentMission.inGameMenu.pageAnimals.selectedCluster
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(selectedCluster:getSubTypeIndex())
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth

    if subType.supportsReproduction then
        if selectedCluster.age >= neededAge and selectedCluster.hadABirth then
            return string.format("%s: %s", g_i18n:getText("EAS_MonthSinceLastBirth"), selectedCluster.monthsSinceLastBirth)
        else
            return g_i18n:getText("EAS_HasNoBirthYet")
        end
    else
        return ""
    end
end