-- Name: EAS_AddSpecialization
-- Author: Chissel

local modDirectory = g_currentModDirectory

g_easUtils = {}
g_easSettingsMenuExtension = {}

local function loadedMission()
    g_gui:loadProfiles(modDirectory.."gui/EAS_guiProfiles.xml")
end

local function init()
    source(Utils.getFilename("src/EAS_Utils.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_AnimalsMenuExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_SettingsMenuExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_UpdateOvercrowdingStateEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_AnimalsCanDieStateEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_SyncSettingsEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_PlaceableHusbandryAnimalsExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_AnimalClusterExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_PlaceableHusbandryMilkExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_PlaceableHusbandryFoodExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/EAS_LivestockTrailerExtension.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_InseminateClusterEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_RemoveMoneyEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/events/EAS_UpdateAutomaticInseminationStateEvent.lua", g_currentModDirectory))
    source(Utils.getFilename("src/gui/EAS_NumberPickerDialog.lua", g_currentModDirectory))
    g_easUtils = EAS_Utils()

    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission)

    local easAnimalsMenuExtension = EAS_AnimalsMenuExtension
    easAnimalsMenuExtension:init()

    g_easSettingsMenuExtension = EAS_SettingsMenuExtension
    g_easSettingsMenuExtension:init()

    if g_placeableSpecializationManager:getSpecializationByName("EnhancedAnimalSystem") == nil then
        g_placeableSpecializationManager:addSpecialization("EnhancedAnimalSystem", "EnhancedAnimalSystem", Utils.getFilename("src/EnhancedAnimalSystem.lua", g_currentModDirectory), nil)
        g_placeableSpecializationManager:addSpecialization("EAS_PlaceableHusbandryGoatMilk", "EAS_PlaceableHusbandryGoatMilk", Utils.getFilename("src/EAS_PlaceableHusbandryGoatMilk.lua", g_currentModDirectory), nil)
    end

    for placeableType, placeable in pairs(g_placeableTypeManager:getTypes()) do
        if SpecializationUtil.hasSpecialization(PlaceableHusbandryAnimals, placeable.specializations) then
            if placeableType == "sheepHusbandry" then
                g_placeableTypeManager:addSpecialization(placeableType, "EAS_PlaceableHusbandryGoatMilk")
            end
        end
    end

	TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, function(self)
		if self.typeName == "placeable" then
			for placeableType, placeable in pairs(g_placeableTypeManager:getTypes()) do
				if SpecializationUtil.hasSpecialization(PlaceableHusbandryAnimals, placeable.specializations) then
					g_placeableTypeManager:addSpecialization(placeableType, "EnhancedAnimalSystem")
				end
			end
		end
	end)

    g_easUtils:logText("EAS_AddSpecialization init done")
end

init()