-- ============================================================= --
-- DisableTurnOffMotor
-- Curato Farms
-- ============================================================= --

DisableTurnOffMotor = {};
addModEventListener(DisableTurnOffMotor);


function Motorized:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self.spec_motorized

	if self.isServer then
		if not g_currentMission.missionInfo.automaticMotorStartEnabled and spec.isMotorStarted and not self:getIsAIActive() then
			local isEntered = self.getIsEntered ~= nil and self:getIsEntered()
			local isControlled = self.getIsControlled ~= nil and self:getIsControlled()

			if not isEntered and not isControlled then
				local isPlayerInRange = false

				for _, player in pairs(g_currentMission.players) do
					if player.isControlled then
						local distance = calcDistanceFrom(self.rootNode, player.rootNode)

						if distance < 250 then
							isPlayerInRange = true

							break
						end
					end
				end

				if not isPlayerInRange then
					for _, enterable in pairs(g_currentMission.enterables) do
						if enterable.spec_enterable ~= nil and enterable.spec_enterable.isControlled then
							local distance = calcDistanceFrom(self.rootNode, enterable.rootNode)

							if distance < 250 then
								isPlayerInRange = true

								break
							end
						end
					end
				end

				-- if isPlayerInRange then
					-- spec.motorStopTimer = spec.motorStopTimerDuration
				-- else
					-- spec.motorStopTimer = spec.motorStopTimer - dt

					-- if spec.motorStopTimer <= 0 then
						-- self:stopMotor()
					-- end
				-- end
			end
		end

		if spec.isMotorStarted then
			self:updateMotorTemperature(dt)
		elseif g_currentMission.missionInfo.automaticMotorStartEnabled and self.getIsControlled ~= nil and self:getIsControlled() and self:getCanMotorRun() then
			self:startMotor(true)
		end
	end

	if self.isClient then
		if self:getIsMotorStarted() then
			if spec.exhaustParticleSystems ~= nil then
				for _, ps in pairs(spec.exhaustParticleSystems) do
					local scale = MathUtil.lerp(spec.exhaustParticleSystems.minScale, spec.exhaustParticleSystems.maxScale, spec.motor:getEqualizedMotorRpm() / spec.motor:getMaxRpm())

					ParticleUtil.setEmitCountScale(spec.exhaustParticleSystems, scale)
					ParticleUtil.setParticleLifespan(ps, ps.originalLifespan * scale)
				end
			end

			if spec.exhaustFlap ~= nil then
				local minRandom = -0.1
				local maxRandom = 0.1
				local angle = MathUtil.lerp(minRandom, maxRandom, math.random()) + spec.exhaustFlap.maxRot * spec.motor:getEqualizedMotorRpm() / spec.motor:getMaxRpm()
				angle = MathUtil.clamp(angle, 0, spec.exhaustFlap.maxRot)

				if spec.exhaustFlap.rotationAxis == 1 then
					setRotation(spec.exhaustFlap.node, angle, 0, 0)
				elseif spec.exhaustFlap.rotationAxis == 2 then
					setRotation(spec.exhaustFlap.node, 0, angle, 0)
				else
					setRotation(spec.exhaustFlap.node, 0, 0, angle)
				end
			end

			if spec.exhaustEffects ~= nil then
				for _, effect in pairs(spec.exhaustEffects) do
					local posX, posY, posZ = localToWorld(effect.effectNode, 0, 0.5, 0)

					if effect.lastPosition == nil then
						effect.lastPosition = {
							posX,
							posY,
							posZ
						}
					end

					local vx = (posX - effect.lastPosition[1]) * 10
					local vy = (posY - effect.lastPosition[2]) * 10
					local vz = (posZ - effect.lastPosition[3]) * 10
					local ex, ey, ez = localToWorld(effect.effectNode, 0, 1, 0)
					vz = ez - vz
					vy = ey - vy + effect.upFactor
					vx = ex - vx
					local lx, ly, lz = worldToLocal(effect.effectNode, vx, vy, vz)
					local distance = MathUtil.vector2Length(lx, lz)
					lx, lz = MathUtil.vector2Normalize(lx, lz)
					ly = math.abs(math.max(ly, 0.01))
					local xFactor = math.atan(distance / ly) * (1.2 + 2 * ly)
					local yFactor = math.atan(distance / ly) * (1.2 + 2 * ly)
					local xRot = math.atan(lz / ly) * xFactor
					local zRot = -math.atan(lx / ly) * yFactor
					effect.xRot = effect.xRot * 0.95 + xRot * 0.05
					effect.zRot = effect.zRot * 0.95 + zRot * 0.05
					local rpmScale = spec.motor:getEqualizedMotorRpm() / spec.motor:getMaxRpm()
					local scale = MathUtil.lerp(effect.minRpmScale, effect.maxRpmScale, rpmScale)

					setShaderParameter(effect.effectNode, "param", effect.xRot, effect.zRot, 0, scale, false)

					local r = MathUtil.lerp(effect.minRpmColor[1], effect.maxRpmColor[1], rpmScale)
					local g = MathUtil.lerp(effect.minRpmColor[2], effect.maxRpmColor[2], rpmScale)
					local b = MathUtil.lerp(effect.minRpmColor[3], effect.maxRpmColor[3], rpmScale)
					local a = MathUtil.lerp(effect.minRpmColor[4], effect.maxRpmColor[4], rpmScale)

					setShaderParameter(effect.effectNode, "exhaustColor", r, g, b, a, false)

					effect.lastPosition[1] = posX
					effect.lastPosition[2] = posY
					effect.lastPosition[3] = posZ
				end
			end

			spec.lastFuelUsageDisplayTime = spec.lastFuelUsageDisplayTime + dt

			if spec.lastFuelUsageDisplayTime > 250 then
				spec.lastFuelUsageDisplayTime = 0
				spec.lastFuelUsageDisplay = spec.fuelUsageBuffer:getAverage()
			end

			spec.fuelUsageBuffer:add(spec.lastFuelUsage)
		end

		if spec.clutchCrackingTimeOut < g_time then
			if g_soundManager:getIsSamplePlaying(spec.samples.clutchCracking) then
				g_soundManager:stopSample(spec.samples.clutchCracking)
			end

			if spec.clutchCrackingGearIndex ~= nil then
				self:setGearLeversState(0, nil, 500)
			end

			if spec.clutchCrackingGroupIndex ~= nil then
				self:setGearLeversState(nil, 0, 500)
			end

			spec.clutchCrackingTimeOut = math.huge
		end

		if isActiveForInputIgnoreSelection then
			if g_currentMission.missionInfo.automaticMotorStartEnabled and not self:getCanMotorRun() then
				local warning = self:getMotorNotAllowedWarning()

				if warning ~= nil then
					g_currentMission:showBlinkingWarning(warning, 2000)
				end
			end

			Motorized.updateActionEvents(self)
		end
	end
end

